--[[local base = _G

local debug = base.debug
local require = base.require
local table = base.table
local pairs = base.pairs
local string = base.string]]

local DbOption  = require('Options.DbOption')
local i18n		  = require('i18n')
local lfs       = require("lfs")

local _ = i18n.ptranslate

--module('optionsModsScripts')

--local modLiveries = {}
--	table 'modLiveries' will be filled by function 'scan_modLiveries_in_dir'
--	modLiveries = {
--		["XXXX"] = { -- current module\Liveries\XXXX\default ...
--   		[1] = "default",
--   		[2] = "english",
--   		...
--   	},
-- 	}

function FileMode( filepath, filename )
	-- IGNORE, fast return
	if filename == "." or filename == ".." then
		return
	end

	local attr,err = lfs.attributes ( filepath .. "\\" .. filename )
	-- our interest
	if attr and (attr.mode == "directory" or attr.mode == "file")then
		return attr.mode
	end

	return 
end

--
-- fill table 'modLiveries' with Liveries info of all available Mods
--
function scan_TerrainLiveries_in_dir( path )
    local modLiveries = {}
    modLiveries = {
      ['LandTexturesSpring'] = {},
      ['LandTexturesSpringOther'] = {},
      ['LandTexturesSummer'] = {},
      ['LandTexturesSummerOther'] = {},
      ['LandTexturesAutumn'] = {},
      ['LandTexturesAutumnOther'] = {},
      ['LandTexturesWinter'] = {},
      ['LandTexturesWinterOther'] = {},
      ['LandTextures'] = {},
      ['Buildings_textures'] = {},
    }
    
    table.insert(modLiveries['LandTexturesSpring'], 1, 'default')
    table.insert(modLiveries['LandTexturesSpringOther'], 1, 'default')
    table.insert(modLiveries['LandTexturesSummer'], 1, 'default')
    table.insert(modLiveries['LandTexturesSummerOther'], 1, 'default')
    table.insert(modLiveries['LandTexturesAutumn'], 1, 'default')
    table.insert(modLiveries['LandTexturesAutumnOther'], 1, 'default')
    table.insert(modLiveries['LandTexturesWinter'], 1, 'default')
    table.insert(modLiveries['LandTexturesWinterOther'], 1, 'default')
    table.insert(modLiveries['LandTextures'], 1, 'default')
    table.insert(modLiveries['Buildings_textures'], 1, 'default')
    
    
	--for modname in lfs.dir( path ) do
		if "directory" == FileMode( path, "vfstextures" )
		then
			for liveryclass in lfs.dir( path .. "\\vfstextures" ) do
				if "directory" == FileMode( path .. "\\vfstextures", liveryclass ) then
        
          if "file" == FileMode( path .. "\\vfstextures\\" .. liveryclass, "description.lua" ) then
            -- all check ok, insert this mod Liveries info into global table modLiveries
            
            local category = ''
            local fname = loadfile(path .. "\\vfstextures\\" .. liveryclass .. "\\description.lua")
            category = fname() or ''
            
            if category and category ~= '' then
              modLiveries[category] = modLiveries[category] or {}
              
              table.insert( modLiveries[category], liveryclass)
              
            end
          end -- of if description.lua is file
          
				end -- of if liveryclass is directory
			end -- of for liveryclass
		end -- of if modname is directory and modname\\Liveries is directory
	--end -- of for modname
    return modLiveries
end -- of function scan_modLiveries_in_dir

function firstToUpper(str)
    return (str:gsub("^%l", string.upper))
end


function getTblCustomTT(modulelocation)
    modLiveries = {}
    modLiveries = scan_TerrainLiveries_in_dir(modulelocation)
    
    local tblCPLocalList = {}
    if modLiveries then
        for category, liveryclass in pairs(modLiveries) do
            local tblItems = {}
            for k, v in pairs(liveryclass) do
                local opname = firstToUpper(v)
                table.insert(tblItems, DbOption.Item(_(opname.."_liv",opname)):Value(v))	                
            end
            tblCPLocalList[category] = DbOption.new():setValue(liveryclass[1]):combo(tblItems)
        end
        
        return tblCPLocalList
    end
    
    
end


-- find the relative location of optionsDb.lua
function script_path() 
    -- remember to strip off the starting @ 
	local luafileloc = debug.getinfo(2, "S").source:sub(2)
	local ti, tj = string.find(luafileloc, "Options")
	local temploc = string.sub(luafileloc, 1, ti-1)
    return temploc
end 

-- find module path
local relativeloc = script_path()
modulelocation = lfs.currentdir().."\\"..relativeloc

local tblCPLocalList = getTblCustomTT(modulelocation)


local result = {}

result["CPList_Spring"]    = tblCPLocalList["LandTexturesSpring"]
result["CPList_SpringO"]   = tblCPLocalList["LandTexturesSpringOther"]
result["CPList_Summer"]    = tblCPLocalList["LandTexturesSummer"]
result["CPList_SummerO"]   = tblCPLocalList["LandTexturesSummerOther"]
result["CPList_Autumn"]    = tblCPLocalList["LandTexturesAutumn"]
result["CPList_AutumnO"]   = tblCPLocalList["LandTexturesAutumnOther"]
result["CPList_Winter"]    = tblCPLocalList["LandTexturesWinter"]
result["CPList_WinterO"]   = tblCPLocalList["LandTexturesWinterOther"]

result["CPList_LandT"]     = tblCPLocalList["LandTextures"]
result["CPList_Building"]  = tblCPLocalList["Buildings_textures"]

return result
